/****************************************************************************
 *   $Id:: lpc13Axx_pmu.h 3635 2010-06-02 00:31:46Z usb00423                  $
 *   Project: NXP LPC13Axx PMU example
 *
 *   Description:
 *     This file contains PMU code header definition.
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/
#ifndef __PMU_H 
#define __PMU_H

#define TEST_DEEPPOWERDOWN    0

#define MCU_SLEEP             0
#define MCU_DEEP_SLEEP        1
#define MCU_POWER_DOWN        2

/* System Low Power ----------------------------------------------------------*/
#define NVIC_LP_SEVONPEND     (0x10)
#define NVIC_LP_SLEEPDEEP     (0x04)
#define NVIC_LP_SLEEPONEXIT   (0x02)

/* PCON bit definition */
#define PCON_NODPD            (0x1<<3)
#define PCON_SLEEPFLAG        (0x1<<8)
#define PCON_DPDFLAG          (0x1<<11)

#define STARTERP0_PINT0       (0x1<<0)
#define STARTERP0_PINT1       (0x1<<1)
#define STARTERP0_PINT2       (0x1<<2)
#define STARTERP0_PINT3       (0x1<<3)
#define STARTERP0_PINT4       (0x1<<4)
#define STARTERP0_PINT5       (0x1<<5)
#define STARTERP0_PINT6       (0x1<<6)
#define STARTERP0_PINT7       (0x1<<7)

#define STARTERP1_RTCINT      (0x1<<12)
#define STARTERP1_WWDT_BODINT (0x1<<13)
#define STARTERP1_USB_WAKEUP	(0x1<<19)
#define STARTERP1_GROUP0INT   (0x1<<20)
#define STARTERP1_GROUP1INT   (0x1<<21)
#define STARTERP1_USART1_4    (0x1<<23)
#define STARTERP1_USART2_3    (0x1<<24)

void PMU_Init( void );
void PMU_Sleep( uint32_t SleepMode, uint32_t SleepCtrl );
void PMU_DeepPowerDown( void );

#endif /* end __PMU_H */
/*****************************************************************************
**                            End Of File
******************************************************************************/
